#ifndef DATABODY_H_
#define DATABODY_H_


#include "DataObject.h"

namespace DataTypes
{

class DataBody: public DataTypes::DataObject
{
public:
	DataBody();
	virtual ~DataBody();
	DataBody(int bodyid, int materialid, float mass, Vector3f linearvelocity, Vector3f angularvelocity);
	int GetMaterialId();
	int GetBodyId();
	Vector3f GetLinearVelocity();
	Vector3f GetAngularVelocity();
	void SetMateriaId(int value);
	float GetMass();
	void SetMass(float value);
	void SetAngularVelocity(Vector3f value);
	void SetLinearVelocity(Vector3f value);
	void SetBodyId(int id);
	virtual string ToString()=0;
private:
	int bodyid;
	int materialid;
	float mass;
	Vector3f linearvelocity;
	Vector3f angularvelocity;
};

}

#endif /*DATABODY_H_*/
